## @file
#  Platform configuration file.
#
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2010 - 2018 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##

#
# TRUE is ENABLE. FALSE is DISABLE.
#

#
# BIOS build switches configuration
#
  gSiPkgTokenSpaceGuid.PcdOptimizeCompilerEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdErbEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdSkipFspTempRamInitAndExit|FALSE

  gPlatformModuleTokenSpaceGuid.PcdUpServerEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdOpalPasswordEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdDeprecatedFunctionRemove|TRUE
  gSiPkgTokenSpaceGuid.PcdMinTreeEnable|FALSE      # AdvancedFeaturesContent
# CPU
  gSiPkgTokenSpaceGuid.PcdSourceDebugEnable|FALSE
  gSiPkgTokenSpaceGuid.PcdTxtEnable|TRUE  #Set to FALSE for GCC Build @todo Convert TXT ASM to NASM
  gSiPkgTokenSpaceGuid.PcdBiosGuardEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdDtsEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdScleanTestEnable|FALSE

# SA
  gSiPkgTokenSpaceGuid.PcdIgdEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdIgdIntHookEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdPegEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSgEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSaDmiEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSkycamEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdGmmEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSaOcEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdVtdEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdPeiDisplayEnable|TRUE

# ME
  gSiPkgTokenSpaceGuid.PcdAmtEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdAtaEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdPttEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdJhiEnable|TRUE

  gPlatformModuleTokenSpaceGuid.PcdAcpiDebugFeatureEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdAcpiEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdAhciEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdBdatEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdBeepStatusCodeEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdBootGuardEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdBootTimeEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable|TRUE  #Set to FALSE for GCC Build @todo Make CSME update seperate driver only built with MSVC
  gPlatformModuleTokenSpaceGuid.PcdCodeCoverageEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdConSplitterEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdCpuIoPpiEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdIntegratedTouchEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdVirtualKeyboardEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdTouchInputFilterEnabled|TRUE
  gSiPkgTokenSpaceGuid.PcdCpuPowerOnConfigEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdCryptoEnable|TRUE    # Current Smbios implementation needs this
  gSiPkgTokenSpaceGuid.PcdSiCsmEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdDataHubEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdDxeCompressEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdDxeCrc32SectionEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdEbcEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdEcEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdEvLoaderEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdFatEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdGopConfigBin|TRUE
  gPlatformModuleTokenSpaceGuid.PcdGpioExpanderEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdGraphicsConsoleEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdHddPasswordEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdHpetEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdIntelRaidEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdIsaSerialStatusCodeEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdJpgEnable|TRUE
  gClientCommonModuleTokenSpaceGuid.PcdKeyboardLedSyncEnable|TRUE # AdvancedFeaturesContent
  gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|FALSE # AdvancedFeaturesContent
  gPlatformModuleTokenSpaceGuid.PcdLfmaEnable|FALSE                # Load module at fixed address feature
  gPlatformModuleTokenSpaceGuid.PcdLzmaEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdMemoryDownEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdMemoryTestEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdMouseEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdMpTableEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdNetworkEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdNetworkIp6Enable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdNetworkIscsiEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdNetworkVlanEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdTraceHubEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdNvmeEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdOverclockEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdPciHotplugEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdPostCodeStatusCodeEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdPpmEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdPhysicalPresent|FALSE
  gPlatformModuleTokenSpaceGuid.PcdPlatformCmosAccessSupport|TRUE
  gPlatformModuleTokenSpaceGuid.PcdRamSerialStatusCodeEnable|FALSE
  gSiPkgTokenSpaceGuid.PcdS3Enable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdS4Enable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSaveMemoryConfigEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSavePegConfigEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdScsiEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable|TRUE  # AdvancedFeaturesContent
  gSiPkgTokenSpaceGuid.PcdSerialGpioEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSetupEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdTbtEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSimpleBootFlagEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSipkgBinaryEnable|FALSE
  gSiPkgTokenSpaceGuid.PcdSmbiosEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSmiVariableEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSmmProfileEnable|FALSE
  gSiPkgTokenSpaceGuid.PcdSmmVariableEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSoftwareGuardEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdSourceDebugUseUsb|FALSE
  gSiPkgTokenSpaceGuid.PcdSsaFlagEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdDcttFlagEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdOptimizationEnable|FALSE       # Base Memory Library Optimization Switch
  gPlatformModuleTokenSpaceGuid.PcdTerminalEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdTpmEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdTpm2Enable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdUefiMiniShellEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdUefiShellEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdUnicodeCollectionEnable|TRUE   # The shell requires a collation protocol.  Setting this TRUE installs the default (Unicode using English language rules) module
  gPlatformModuleTokenSpaceGuid.PcdUsbEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdUseHpetTimer|TRUE                       # TRUE - HPET / FALSE - 8254 timer is used.
  gPlatformModuleTokenSpaceGuid.PcdUserIdentificationEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdVariableInfoEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdUnitoolEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdUsbTypeCEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdGopOverrideDriverEnable|FALSE # AdvancedFeaturesContent
  gSiPkgTokenSpaceGuid.PcdOcWdtEnable|TRUE
  gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable|FALSE
  gPlatformModuleTokenSpaceGuid.PcdUserAuthenticationEnable|TRUE # AdvancedFeaturesContent

  #
  # Build Switch for bin files.
  #
  gPlatformModuleTokenSpaceGuid.PcdPubKeyHashBinEnable|TRUE             #pubkeyhash.bin
  gPlatformModuleTokenSpaceGuid.PcdStartupAcmBinEnable|TRUE             #StartupAcm.bin
  gPlatformModuleTokenSpaceGuid.PcdBiosAcmBinEnable|TRUE                #BiosAc.bin
  gPlatformModuleTokenSpaceGuid.PcdAcmProdBinEnable|FALSE               #BiosAcProd.bin and SinitAcProd.bin
  gPlatformModuleTokenSpaceGuid.PcdSinitAcmBinEnable|FALSE              #SinitAc.bin
  gPlatformModuleTokenSpaceGuid.PcdReservedFitBinEnable|TRUE            #ReservedFIT.bin
  gPlatformModuleTokenSpaceGuid.PcdCsmLegacy16BinEnable|TRUE            #AmiLegacy16.bin
  gPlatformModuleTokenSpaceGuid.PcdSredirBinEnable|TRUE                 #Sredir.bin
  gPlatformModuleTokenSpaceGuid.PcdRsteOromBinEnable|TRUE               #RsteRaidOrom.bin
  gPlatformModuleTokenSpaceGuid.PcdRaidOromBinEnable|TRUE               #RaidOrom.bin
  gPlatformModuleTokenSpaceGuid.PcdAhciOromBinEnable|TRUE               #AHCIOR.BIN
  gPlatformModuleTokenSpaceGuid.PcdGigUndiEnable |TRUE                  #PxeUndiRom.BIN and E0013X7.EFI
  gPlatformModuleTokenSpaceGuid.PcdUi13BinEnable|TRUE                   #UI13.bin
  gPlatformModuleTokenSpaceGuid.PcdIntelGopEnable|TRUE                  #LegacyVideoRom.bin and IntelGopDriver.efi
  gPlatformModuleTokenSpaceGuid.PcdStmBinEnable|TRUE                    #Stm.bin
  gPlatformModuleTokenSpaceGuid.PcdGopVbtBinEnable|TRUE                 #Vbt.bin
  gPlatformModuleTokenSpaceGuid.PcdPsmihandlerBinEnable|TRUE            #PsmiHandler.bin
  gPlatformModuleTokenSpaceGuid.PcdMeBinEnable|TRUE                     #Me.bin
  gPlatformModuleTokenSpaceGuid.PcdFcntrlBinEnable|TRUE                 #Fcntrl.bin
  gPlatformModuleTokenSpaceGuid.PcdEcBinEnable|TRUE                     #Ksc.bin
  gPlatformModuleTokenSpaceGuid.PcdBaseEcBinEnable|TRUE                 #BaseEc.bin
  gPlatformModuleTokenSpaceGuid.PcdEcBgUpBinEnable|TRUE                 #KscBGUP.bin
  gPlatformModuleTokenSpaceGuid.PcdBgupCapsuleBinEnable|TRUE            #BGUP_$(TARGET)_CAPSULE.bin

  #
  # Build Switch for efi files.
  #
  gPlatformModuleTokenSpaceGuid.PcdSectionextractiondxeEfiEnable|TRUE   #SectionExtractionDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdFwvoldxeEfiEnable|TRUE               #FwVolDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdFaulttolerantwritedxeEfiEnable|TRUE  #FaultTolerantWriteDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdUpdateDriverDxeEfiEnable|TRUE        #UpdateDriverDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdIccOverClockingBinEnable|TRUE        #IccOverClocking.efi
  gPlatformModuleTokenSpaceGuid.PcdUhcdBinEnable|TRUE                   #Uhcd.efi
  gPlatformModuleTokenSpaceGuid.PcdUsbRtBinEnable|TRUE                  #UsbRt.efi
  gPlatformModuleTokenSpaceGuid.PcdUsbInt13BinEnable|TRUE               #UsbInt13.efi
  gPlatformModuleTokenSpaceGuid.PcdKbcEmulEfiEnable|TRUE                #KbcEmul.efi & KbcEmulDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdLegacySredirBinEnable|TRUE           #LegacySredir.efi
  gPlatformModuleTokenSpaceGuid.PcdRaidDriverEfiEnable|TRUE             #RaidDriver.efi
  gPlatformModuleTokenSpaceGuid.PcdRaidDriverSmmEfiEnable|TRUE          #RaidDriverSmm.efi
  gPlatformModuleTokenSpaceGuid.PcdRsteDriverEfiEnable|TRUE             #SataDriverRste.efi
  gPlatformModuleTokenSpaceGuid.PcdRstNvmeDriverEfiEnable|TRUE          #RstNvmeDriver.efi
  gPlatformModuleTokenSpaceGuid.PcdMebxEfiEnable|TRUE                   #Mebx.efi
  gPlatformModuleTokenSpaceGuid.PcdMebxSetupBrowserEnable|TRUE          #MebxSetupBrowser.efi
  gPlatformModuleTokenSpaceGuid.PcdUefiShellBuildSource|FALSE           #Shell.efi
  gPlatformModuleTokenSpaceGuid.PcdUsbFnEnable|TRUE                     #UsbDeviceDxe.efi
  gPlatformModuleTokenSpaceGuid.PcdRstOneClickEnable|TRUE               #RstOneClickEnable.efi

  gPlatformModuleTokenSpaceGuid.PcdPiI2cStackEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdI2cTouchDriverEnable|TRUE
  gPlatformModuleTokenSpaceGuid.PcdVirtualKeyboardEnable|TRUE


  gPlatformModuleTokenSpaceGuid.PcdEnableSecureErase|TRUE

